const mongoose = require("mongoose");

const adminSchema = mongoose.Schema(
  {
    name: {
      type: String,
      required: true,
      default: "Admin User",
    },
    email: {
      type: String,
      required: true,
      unique: true,
    },
    password: {
      type: String,
      required: true,
    },
    userType: {
      type: String,
      default: "Admin",
    },
    access: {
      type: String,
      default: "true",
    },
  },
  { versionKey: false, timestamps: true }
);

const AdminModel =
  mongoose.models.Admin || mongoose.model("Admin", adminSchema);

module.exports = AdminModel;
